# 画面設計書 11-Simple INI File Browser

## 概要

本ドキュメントは、VBCorLibのIniFileクラス機能をデモンストレーションするSimple INI File Browser画面の設計書である。

### 本画面の処理概要

この画面は、Windows標準のINI設定ファイルを閲覧するためのビューアアプリケーションである。INIファイル内のセクション一覧表示、セクション内のキー・値ペア表示、およびカスタムソート機能を備えている。

**業務上の目的・背景**：Windows環境では多くのアプリケーションがINIファイル形式で設定を保存している。このデモ画面は、VBCorLibが提供するIniFileクラスの機能（セクション取得、キー・値ペア取得）をVB6開発者に紹介し、INIファイル操作の実装方法を学習できるようにすることを目的としている。また、CorArrayによるソート機能やCaseInsensitiveComparerによる大小文字無視比較の使い方も併せてデモンストレーションしている。

**画面へのアクセス方法**：SimpleINIFileBrowser.vbpプロジェクトをVB6 IDEで開き、実行（F5）することでフォームが起動する。スタートアップフォームとしてForm1が設定されている。

**主要な操作・処理内容**：
1. メニューの「File > Open」からINIファイルを選択する
2. 左側のListBoxにINIファイル内の全セクション名がアルファベット順（大小文字無視）でソートされて表示される
3. セクションを選択すると、右側のListViewにそのセクション内のキー・値ペアがアルファベット順でソートされて表示される
4. NT系Windows環境では、一部の値がレジストリから取得される場合がある

**画面遷移**：本画面は独立したデモアプリケーションであり、他の画面への遷移は存在しない。ファイルオープンダイアログ（CommonDialog）のみが呼び出される。

**権限による表示制御**：特になし。ローカルファイルシステムへの読み取りアクセス権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 40 | IniFile | 主機能 | INIファイルの読み込みと解析（GetSectionNames、GetValues） |
| 1 | CorArray | 補助機能 | セクション名のソート処理（Sort） |
| 24 | Comparer | 補助機能 | 大小文字を区別しない比較（CaseInsensitiveComparer.Default） |
| 18 | ArrayList | 補助機能 | 辞書エントリのソート（AddRange、Sort） |

## 画面種別

一覧（マスター・ディテール形式）

## URL/ルーティング

該当なし（VB6デスクトップアプリケーション）

## 入出力項目

### 入力項目

| 項目名 | データ型 | 必須 | 説明 |
|--------|----------|------|------|
| INIファイルパス | String | Yes | CommonDialogで選択されるINIファイルのフルパス |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| セクション名一覧 | String配列 | INIファイル内の全セクション名（ソート済み） |
| キー・値ペア | DictionaryEntry | 選択セクション内のキーと値のペア |

## 表示項目

### セクションリスト（List1）

| 項目名 | 説明 |
|--------|------|
| セクション名 | INIファイル内の各セクション名 |

### キー・値リスト（ListView1）

| 列名 | 幅 | 説明 |
|------|-----|------|
| Key | 2500 twips | INIファイルのキー名 |
| Value | 2500 twips | キーに対応する値 |

## イベント仕様

### 1-Form_Load

フォーム初期化時に実行される。ListViewのカラムヘッダー（Key、Value）を設定する。

**処理フロー**：
1. ListView1のColumnHeadersにKey列（幅2500）を追加
2. ListView1のColumnHeadersにValue列（幅2500）を追加

### 2-mnuFileOpen_Click

メニューの「File > Open」クリック時に実行される。

**処理フロー**：
1. CommonDialogでINIファイル選択ダイアログを表示（フィルタ: *.ini または *.*）
2. キャンセル時はエラートラップで処理を終了
3. NewINIFile関数でINIFileオブジェクトを生成
4. フォームのCaptionにファイル名を追加表示
5. ShowSections関数を呼び出してセクション一覧を表示
6. ListView1のリストをクリア

### 3-List1_Click

セクションリストでアイテムクリック時に実行される。

**処理フロー**：
1. mFile.GetValuesで選択セクションのキー・値ペアを取得（IDictionary）
2. ListView1をクリア
3. SortDictionary関数でソート済みArrayListに変換
4. For Eachで各DictionaryEntryをListView1に追加

### 4-ShowSections（Private Sub）

INIファイル内の全セクション名を取得・表示する内部処理。

**処理フロー**：
1. mFile.GetSectionNamesでセクション名配列を取得
2. CorArray.SortでCaseInsensitiveComparer.Defaultを使用してソート
3. List1をクリア
4. For文で各セクション名をList1に追加

### 5-SortDictionary（Private Function）

IDictionaryをソート済みArrayListに変換する内部処理。

**処理フロー**：
1. 新しいArrayListを生成
2. AddRangeでIDictionaryの全エントリを追加
3. INIEntryComparerを使用してソート
4. ソート済みArrayListを返却

## データベース更新仕様

該当なし（INIファイルの読み取りのみ）

## メッセージ仕様

| 種別 | 条件 | メッセージ内容 |
|------|------|---------------|
| 情報 | ファイル選択完了 | タイトルバーに「Simple INI File Browser - {ファイル名}」を表示 |

## 例外処理

| 例外条件 | 処理内容 |
|----------|----------|
| ファイル選択キャンセル | errTrapラベルへジャンプし、処理を終了（エラー表示なし） |
| ファイル読み込みエラー | VBのデフォルトエラー処理に委譲 |

## 備考

- MSCOMCTL.OCX（TreeView、ListView等のコモンコントロール）が必要
- COMDLG32.OCX（CommonDialog）が必要
- VBCorLib 3.0ライブラリ（vbcorlib3.dll）への参照設定が必要
- NT系Windows環境では、一部のINI値がレジストリから取得される（Windowsの互換性機能による）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、INIファイルのデータ構造とそれを扱うVBCorLibのクラス構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INIEntryComparer.cls | `Examples/IO Examples/SimpleINIFileBrowser/INIEntryComparer.cls` | DictionaryEntryオブジェクトの比較方法を理解する。IComparerインターフェースの実装方法を学ぶ |

**読解のコツ**: VB6のImplementsキーワードによるインターフェース実装パターンを確認する。IComparer_Compare関数がソート時に呼び出されるコールバックである。

#### Step 2: エントリーポイントを理解する

処理の起点となるフォームのイベントハンドラを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Form1.frm | `Examples/IO Examples/SimpleINIFileBrowser/Form1.frm` | フォームの初期化処理とユーザー操作によるイベント処理の流れを理解する |

**主要処理フロー**:
1. **行77-82（Form_Load）**: フォーム初期化。ListViewのカラムヘッダー設定
2. **行114-129（mnuFileOpen_Click）**: ファイルオープン処理。INIFileオブジェクト生成とセクション表示
3. **行90-110（List1_Click）**: セクション選択時のキー・値表示処理
4. **行134-149（ShowSections）**: セクション名一覧の取得・ソート・表示
5. **行154-172（SortDictionary）**: IDictionaryのソート処理

#### Step 3: VBCorLib機能の理解

VBCorLibが提供するINIファイル操作機能を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IniFile（VBCorLib内） | VBCorLibライブラリ内部 | NewINIFile関数、GetSectionNames、GetValuesメソッドの仕様を理解する |

**主要処理フロー**:
- **行120**: NewINIFile関数でINIFileオブジェクトを生成
- **行137**: GetSectionNamesでセクション名配列を取得
- **行94**: GetValuesでセクション内のキー・値をIDictionaryとして取得

### プログラム呼び出し階層図

```
Form1.frm
    │
    ├─ Form_Load (行77)
    │      └─ ListView1.ColumnHeaders.Add (カラム設定)
    │
    ├─ mnuFileOpen_Click (行114)
    │      ├─ CommonDialog.ShowOpen (ファイル選択)
    │      ├─ NewINIFile (VBCorLib) (INIFileオブジェクト生成)
    │      └─ ShowSections (行134)
    │             ├─ INIFile.GetSectionNames (セクション名取得)
    │             ├─ CorArray.Sort (ソート)
    │             │      └─ CaseInsensitiveComparer.Default
    │             └─ List1.AddItem (表示)
    │
    └─ List1_Click (行90)
           ├─ INIFile.GetValues (キー・値取得)
           ├─ SortDictionary (行154)
           │      ├─ ArrayList.AddRange (エントリ追加)
           │      └─ ArrayList.Sort
           │             └─ INIEntryComparer.cls
           │                    └─ IComparer_Compare (行22)
           └─ ListView1.ListItems.Add (表示)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

INIファイル ───────────▶ NewINIFile ───────────────────▶ INIFileオブジェクト
  (.ini)                 (行120)                         (mFile)
                              │
                              ▼
                         GetSectionNames ──────────────▶ セクション名配列
                         (行137)                         (Sections())
                              │
                              ▼
                         CorArray.Sort ────────────────▶ ソート済み配列
                         (行140)
                              │
                              ▼
                         List1.AddItem ────────────────▶ ListBox表示
                         (行147)

ユーザー選択 ────────────▶ GetValues ─────────────────▶ IDictionary
(セクション名)            (行94)                         (Values)
                              │
                              ▼
                         SortDictionary ───────────────▶ ソート済みArrayList
                         (行100)
                              │
                              ▼
                         ListView表示 ─────────────────▶ キー・値一覧
                         (行105-109)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Form1.frm | `Examples/IO Examples/SimpleINIFileBrowser/Form1.frm` | ソース | メインフォーム。UIとイベント処理 |
| INIEntryComparer.cls | `Examples/IO Examples/SimpleINIFileBrowser/INIEntryComparer.cls` | ソース | DictionaryEntryのカスタムコンパレータ |
| SimpleINIFileBrowser.vbp | `Examples/IO Examples/SimpleINIFileBrowser/SimpleINIFileBrowser.vbp` | プロジェクト | VBプロジェクトファイル |
| vbcorlib3.dll | `Binaries/Compiled/vbcorlib3.dll` | ライブラリ | VBCorLibランタイム |
| MSCOMCTL.OCX | System32 | OCX | TreeView/ListViewコントロール |
| COMDLG32.OCX | System32 | OCX | CommonDialogコントロール |
